CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSNUMEROACTA" ("NACTA", 

																"ACTA", 

																"ANOACTA",

																"NACTACOMPLETO", 

																"NUMREGISTRO", 

																"NUMELECTORES", 

																"RAZON", 

																"CIF", 

																"DOMICILIO", 

																"CODIGOCENTRO", 

																"CONVENIO", 

																"CONVENIOEU", 

																"TERRIT", 

																"VER", 

																"DELEGADOSHOMBRES", 

																"DELEGADOSMUJERES", 

																"DESC_026", 

																"DESE_026", 

																"DESC_019", 

																"DESE_019", 

																"DESC_023", 

																"DESE_023", 

																"SIGLAS_019", 

																"C_COLEG_025", 

																"C_SINDI_025", 

																"DNI_025", 

																"NOMBRE_025", 

																"APEL1_025", 

																"APEL2_025", 

																"SEXO_025", 

																"F_BAJA_025", 

																"DNI_SUST_025") AS 

  SELECT DISTINCT (   actas.c_territ_016

                    || '/'

                    || actas.ano_acta_016

                    || '/'

                    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                               1, '00000' || TO_CHAR (actas.n_acta_016),

                               2, '0000' || TO_CHAR (actas.n_acta_016),

                               3, '000' || TO_CHAR (actas.n_acta_016),

                               4, '00' || TO_CHAR (actas.n_acta_016),

                               5, '0' || TO_CHAR (actas.n_acta_016),

                               TO_CHAR (actas.n_acta_016)

                              )

                   ) acta,

                   actas.n_acta_016, actas.ano_acta_016,

                   TO_NUMBER (   actas.ano_acta_016

                              || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),

                                         1, '00000'

                                          || TO_CHAR (actas.n_acta_016),

                                         2, '0000'

                                          || TO_CHAR (actas.n_acta_016),

                                         3, '000'

                                          || TO_CHAR (actas.n_acta_016),

                                         4, '00' || TO_CHAR (actas.n_acta_016),

                                         5, '0' || TO_CHAR (actas.n_acta_016),

                                         TO_CHAR (actas.n_acta_016)

                                        )

                             ),

                   (   actas.c_territ_016

                    || '/'

                    || actas.ano_regdef_016

                    || '/'

                    || DECODE (LENGTH (TO_CHAR (actas.n_regdef_016)),

                               1, '00000' || TO_CHAR (actas.n_regdef_016),

                               2, '0000' || TO_CHAR (actas.n_regdef_016),

                               3, '000' || TO_CHAR (actas.n_regdef_016),

                               4, '00' || TO_CHAR (actas.n_regdef_016),

                               5, '0' || TO_CHAR (actas.n_regdef_016),

                               TO_CHAR (actas.n_regdef_016)

                              )

                   ) registro,

                   actas.totelec_016, centros.rsoc_001, centros.ccif_001,

                   centros.domic_001, centros.ncen_001, conv.desc_013,

                   conv.dese_013, actas.c_territ_016, actas.version_016,

                  actas.delh_016 hombres,

                  actas.delm_016 mujer,

				  desc_026 AS desc26,

				  dese_026 AS dese26,

				  desc_019 AS desc19,

				  dese_019 AS dese19,

				  desc_023 AS desc23,

				  dese_023 AS dese23,

				  siglas_019 AS siglas,

				  C_COLEG_025,

				  C_SINDI_025,

				  DNI_025,

				  NOMBRE_025,

				  APEL1_025,

				  APEL2_025,

				  SEXO_025,

				  TO_CHAR(F_BAJA_025,'dd/MM/yyyy') F_BAJA_025,

				  DNI_SUST_025

              FROM w83b16s00 actas,

                   j7301s01 centros,

                   w83b13s00 conv,

                   w83b25s00 delegados,

				   w83b26t00 baja,

				   w83b19t00 sind, 

				   w83b23s00 col

             WHERE actas.version_016 =

                      (SELECT MAX (version_016)

                         FROM w83b16s00

                        WHERE actas.n_acta_016 = n_acta_016

                          AND actas.c_territ_016 = c_territ_016

                          AND actas.ano_acta_016 = ano_acta_016

						  AND validada_016=1)

               AND actas.id_centro_016 = centros.ccen_001(+)

               AND actas.c_conv_016 = conv.c_conv_013(+)

               AND actas.ano_acta_016 = delegados.ano_acta_025

               AND actas.n_acta_016 = delegados.n_acta_025

               AND actas.c_territ_016 = delegados.c_territ_025

               AND actas.version_016 = delegados.version_025

			   AND delegados.cbaja_025 =  baja.cbaja_026(+)

			   AND delegados.c_sindi_025 = sind.c_sindi_019 

			   AND delegados.c_coleg_025 = col.c_coleg_023

			   AND actas.validada_016=1

               AND (    actas.n_regdef_016 IS NOT NULL

                    AND actas.fregdef_016 IS NOT NULL

                   )

               AND actas.f_baja_016 IS NULL

          ORDER BY acta;

 

/



 /* ************************************************************************************** */

   CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGADOSCNAE" ("NACTA", "ANOACTA", "TERRIT", "VER", "NCENTRO", "TOTALELECTORES", "FELEC", "FECHAREGISTRO", "IDCNAE", "SECTOR", "DESCSECTOR", "DESCCNAE", "C_SINDI_024", "C_COLEG_024", "N_VOTOS_024", "N_DELH_024", "N_DELM_024", "SIGLAS_019") AS 

  (

  SELECT   tact.n_acta_016, tact.ano_acta_016, tact.c_territ_016,

            tact.version_016, tact.id_centro_016, tact.totelec_016,

            tact.f_elecc_016, tact.fregdef_016, tcnae.idcnae, tcnae.idsector,

            tsec.desc_004, tcnae.desccnae,  

			tsind.C_SINDI_019, tesc.C_COLEG_024, tesc.N_VOTOS_024, tesc.N_DELH_024, tesc.N_DELM_024, tsind.SIGLAS_019

       FROM W83B16T00 tact,

            w83b.j7301s01 tcent,

            w83bcnae tcnae,

			w83b24s00 tesc,

            w83b.J7304S00 tsec,

			w83b19s00 tsind

      WHERE tact.version_016 =

               (SELECT MAX (version_016)

                  FROM w83b16s00 act

                 WHERE tact.n_acta_016 = act.n_acta_016

                   AND tact.ano_acta_016 = act.ano_acta_016

                   AND tact.c_territ_016 = act.c_territ_016

				   AND act.validada_016=1)

        AND tact.f_baja_016 IS NULL

        AND tact.n_acttot_016 IS NULL

        AND tact.fregdef_016 IS NOT NULL

        AND tact.id_centro_016 = tcent.ccen_001

        AND tcent.cnae_001 = tcnae.idcnae

        AND tcent.secc_001 = tcnae.idsector

        AND tsec.secc_004 = tcnae.idsector

	   AND tact.validada_016=1

	   AND tact.n_acta_016 = tesc.N_ACTA_024(+)

       AND tact.ano_acta_016 = tesc.ANO_ACTA_024(+)

       AND tact.c_territ_016 = tesc.C_TERRIT_024(+)

	   AND tact.version_016 = tesc.VERSION_024(+)

	   AND tesc.C_SINDI_024 = tsind.C_SINDI_019

)

UNION ALL

(

 SELECT   tact.n_acta_016, tact.ano_acta_016, tact.c_territ_016,

            tact.version_016, tact.id_centro_016, tact.totelec_016,

            tact.f_elecc_016, tact.fregdef_016, tcnae.idcnae, tcnae.idsector,

            tsec.desc_004, tcnae.desccnae,  

			tsind.C_SINDI_019, tdif.C_COLEG_018, 0 as N_VOTOS_024, tdif.N_DELH_018, tdif.N_DELM_018, tsind.SIGLAS_019

       FROM W83B16T00 tact,

            w83b.j7301s01 tcent,

            w83bcnae tcnae,

            w83b.J7304S00 tsec,

			w83b19s00 tsind,

			w83b18s00 tdif

      WHERE tact.version_016 =

               (SELECT MAX (version_016)

                  FROM w83b16s00 act

                 WHERE tact.n_acta_016 = act.n_acta_016

                   AND tact.ano_acta_016 = act.ano_acta_016

                   AND tact.c_territ_016 = act.c_territ_016

				   AND act.validada_016=1)

        AND tact.f_baja_016 IS NULL

        AND tact.n_acttot_016 IS NULL

        AND tact.fregdef_016 IS NOT NULL

        AND tact.id_centro_016 = tcent.ccen_001

        AND tcent.cnae_001 = tcnae.idcnae

        AND tcent.secc_001 = tcnae.idsector

        AND tsec.secc_004 = tcnae.idsector

	   AND tact.validada_016=1

	   AND tact.n_acta_016 = tdif.N_ACTA_018(+)

       AND tact.ano_acta_016 = tdif.ANO_ACTA_018(+)

       AND tact.c_territ_016 = tdif.C_TERRIT_018(+)

	   AND tact.version_016 = tdif.VERSION_018(+)

	   AND tdif.C_SINDI_018 = tsind.C_SINDI_019

	   )

   ORDER BY idsector,

            idcnae,

            c_territ_016,

            ano_acta_016,

            n_acta_016,

            version_016;

/





  CREATE OR REPLACE FORCE VIEW "W83B"."W83BVISTACITACIONES" ("NCITACION", "ANYOIMPUGNACION", "NUMIMPUGNACION", "CODTERRITORIOIMPUGNACION", "FECHAIMPUGNACION", "NUMLAUDO", "IDCENTRO", "NCENTRO", "CIF", "DIRCENTRO", "CPCENTRO", "CODMUNICIPIO", "CODPROVINCIA", "CENTROMUNICIPIOTXTC", "CENTROMUNICIPIOTXTE", "CENTROPROVINCIATXTC", "CENTROPROVINCIATXTE", "RAZONSOCIAL", "DNIIMPUG", "NOMBREIMPUG", "DIRIMPUG", "CPIMPUG", "MUNIIMPUG", "PROVIMPUG", "MUNIIMPUGTXTC", "MUNIIMPUGTXTE", "PROVIMPUGTXTC", "PROVIMPUGTXTE", "MESA", "DIRORIG", "HORACITACIONI", "HORACITACIONF", "LUGARCITACION", "CODSINDICATOS", "ABRSINDICATOS", "DATOSSINDICATOS", "ORDENSIN") AS 

  SELECT      w83b_59s00.c_territ_059

            || '/'

            || w83b_59s00.ano_impugn_059

            || '/'

            || DECODE (LENGTH (TO_CHAR (w83b_59s00.num_impugnac_059)),

                       1, '00000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                       2, '0000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                       3, '000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                       4, '00' || TO_CHAR (w83b_59s00.num_impugnac_059),

                       5, '0' || TO_CHAR (w83b_59s00.num_impugnac_059),

                       TO_CHAR (w83b_59s00.num_impugnac_059)

                      ),

            w83b_59s00.ano_impugn_059,

            DECODE (LENGTH (TO_CHAR (w83b_59s00.num_impugnac_059)),

                    1, '00000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                    2, '0000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                    3, '000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                    4, '00' || TO_CHAR (w83b_59s00.num_impugnac_059),

                    5, '0' || TO_CHAR (w83b_59s00.num_impugnac_059),

                    TO_CHAR (w83b_59s00.num_impugnac_059)

                   ),

            w83b_59s00.c_territ_059, w83b_33s00.f_impug_033,

            DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)),

                    1, '00' || TO_CHAR (w83b_68s00.n_laudo_068),

                    2, '0' || TO_CHAR (w83b_68s00.n_laudo_068),

                    TO_CHAR (w83b_68s00.n_laudo_068)

                   ),

            t73_01s00.ccen_001, t73_01s00.ncen_001, t73_01s00.ccif_001,

            t73_01s00.domic_001, t73_01s00.cposc_001, t73_01s00.munic_001,

            t73_01s00.provc_001, fca02.ds_o, fca02.ds_o, fca01.ds_o,

            fca01.ds_o, t73_01s00.rsoc_001, w83b_59s00.dni_impugn_059,

            w83b_59s00.nombre_imp_059, w83b_59s00.dir_imp_059,

            w83b_59s00.codpos_imp_059, w83b_59s00.munic_imp_059,

            w83b_59s00.prov_impug_059, fca02_impug.ds_o, fca02_impug.ds_o,

            fca01_impug.ds_o, fca01_impug.ds_o, w83b_59s00.mesa_059,

            w83b_59s00.dir_orig_059, w83b_59s00.horadesde_059,

            w83b_59s00.horahasta_059, w83b_59s00.mesa_059,

            stragg_int (w83b_19s00.c_sindi_019),

            stragg_int (w83b_19s00.siglas_019),

            stragg_int (   w83b_19s00.c_sindi_019

                        || '@'

                        || w83b_19s00.desc_019

                        || '@'

                        || w83b_19s00.dese_019

                        || '@'

                        || w83b_60s00.dir_sindi_060

                        || '@'

                        || w83b_60s00.prov_sindi_060

                        || '@'

                        || w83b_60s00.mun_sindi_060

                        || '@'

                        || w83b_60s00.tipo_sindi_060

                        || '@'

                        || w83b_19s00.siglas_019

                        || '@'

                        || w83b_60s00.codpos_060

                       ),

			w83b_59s00.ord_sind_059

       FROM w83b59s00 w83b_59s00,

            w83b68s00 w83b_68s00,

            w83b60s00 w83b_60s00,

            w83b19s00 w83b_19s00,

            w83b33s00 w83b_33s00,

            t17i.t17_municipio fca02_impug,

            t17i.t17_provincia fca01_impug,

            j7301s01 t73_01s00,

            t17i.t17_municipio fca02,

            t17i.t17_provincia fca01

      WHERE c_territ_059 = w83b_60s00.c_territ_060(+)

        AND num_impugnac_059 = w83b_60s00.num_impugnac_060(+)

        AND ano_impugn_059 = w83b_60s00.ano_impugn_060(+)

        AND c_territ_059 = c_territ_068(+)

        AND num_impugnac_059 = n_impug_068(+)

        AND ano_impugn_059 = ano_impug_068(+)

        AND w83b_60s00.c_sindi_060 = w83b_19s00.c_sindi_019(+)

        AND c_territ_059 = w83b_33s00.c_territ_033(+)

        AND num_impugnac_059 = w83b_33s00.n_impug_033(+)

        AND ano_impugn_059 = w83b_33s00.ano_impug_033(+)

        AND prov_impug_059 = fca02_impug.provincia_id(+)

        AND munic_imp_059 = fca02_impug.ID(+)

        AND prov_impug_059 = fca01_impug.ID(+)

        AND w83b_59s00.id_centro_059 = t73_01s00.ccen_001(+)

        AND t73_01s00.provc_001 = fca01.ID(+)

        AND t73_01s00.provc_001 = fca02.provincia_id(+)

        AND t73_01s00.munic_001 = fca02.ID(+)

   GROUP BY    w83b_59s00.c_territ_059

            || '/'

            || w83b_59s00.ano_impugn_059

            || '/'

            || DECODE (LENGTH (TO_CHAR (w83b_59s00.num_impugnac_059)),

                       1, '00000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                       2, '0000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                       3, '000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                       4, '00' || TO_CHAR (w83b_59s00.num_impugnac_059),

                       5, '0' || TO_CHAR (w83b_59s00.num_impugnac_059),

                       TO_CHAR (w83b_59s00.num_impugnac_059)

                      ),

            w83b_59s00.ano_impugn_059,

            w83b_33s00.f_impug_033,

            DECODE (LENGTH (TO_CHAR (w83b_59s00.num_impugnac_059)),

                    1, '00000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                    2, '0000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                    3, '000' || TO_CHAR (w83b_59s00.num_impugnac_059),

                    4, '00' || TO_CHAR (w83b_59s00.num_impugnac_059),

                    5, '0' || TO_CHAR (w83b_59s00.num_impugnac_059),

                    TO_CHAR (w83b_59s00.num_impugnac_059)

                   ),

            w83b_59s00.c_territ_059,

            DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)),

                    1, '00' || TO_CHAR (w83b_68s00.n_laudo_068),

                    2, '0' || TO_CHAR (w83b_68s00.n_laudo_068),

                    TO_CHAR (w83b_68s00.n_laudo_068)

                   ),

            t73_01s00.ccen_001,

            t73_01s00.ncen_001,

            t73_01s00.ccif_001,

            t73_01s00.domic_001,

            t73_01s00.cposc_001,

            t73_01s00.munic_001,

            t73_01s00.provc_001,

            fca02.ds_o,

            fca02.ds_o,

            fca01.ds_o,

            fca01.ds_o,

            t73_01s00.rsoc_001,

            w83b_59s00.dni_impugn_059,

            w83b_59s00.nombre_imp_059,

            w83b_59s00.dir_imp_059,

            w83b_59s00.codpos_imp_059,

            w83b_59s00.munic_imp_059,

            w83b_59s00.prov_impug_059,

            fca02_impug.ds_o,

            fca02_impug.ds_o,

            fca01_impug.ds_o,

            fca01_impug.ds_o,

            w83b_59s00.mesa_059,

            w83b_59s00.dir_orig_059,

            w83b_59s00.horadesde_059,

            w83b_59s00.horahasta_059,

            w83b_59s00.mesa_059,

			w83b_59s00.ord_sind_059;

 

/